//
//  GHSPO2Data.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 3/27/18.
//  Copyright © 2018 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  The GHSPO2Data class provides the SPO2 data that was extracted from the Garmin device.
 */
@interface GHSPO2Data : NSObject <NSCoding>

/** Timestamp for the associated spo2Data. Can be null. */
@property (nullable, nonatomic, readonly) NSDate *timestamp;

/**
 * The SPO2 value. Can be null.
 * @note Values are floats.
 */
@property (nullable, nonatomic, readonly) NSNumber *spo2Reading;

/**
 * The confidence in the spo2Reading value. Can be null.
 * @note Values are integers.
 */
@property (nullable, nonatomic, readonly) NSNumber *confidence;


@end
